#!/bin/bash

# Extract CPU power (sum of SVI2_P_Core and SVI2_P_SoC)
cpu_power=$(sensors | awk '
  /SVI2_P_Core:/ { core_power = $2 }
  /SVI2_P_SoC:/ { soc_power = $2 }
  END { print core_power + soc_power }
')

# Extract AMD GPU power (handles different PCI bus locations)
gpu_power_amd=$(sensors | awk '
  /amdgpu-pci-/ { in_gpu_section = 1 }
  in_gpu_section && /PPT:/ { print $2; exit }
')

# Extract NVIDIA GPU power using nvidia-smi (if available)
if command -v nvidia-smi &> /dev/null; then
    gpu_power_nvidia=$(nvidia-smi --query-gpu=power.draw --format=csv,noheader,nounits 2>/dev/null | awk '{print $1}')
else
    gpu_power_nvidia=0
fi

# Determine which GPU power value to use
gpu_power=${gpu_power_nvidia:-0}
if [[ "$gpu_power" == "0" || -z "$gpu_power" ]]; then
    gpu_power=${gpu_power_amd:-0}
fi

# Ensure numeric values, defaulting to 0 if empty
cpu_power=${cpu_power:-0}
gpu_power=${gpu_power:-0}

# Calculate total power
total_power=$(echo "$cpu_power + $gpu_power" | bc)

# Print results
echo "CPU Power: ${cpu_power} W"
if [[ "$gpu_power_nvidia" != "0" && -n "$gpu_power_nvidia" ]]; then
    echo "NVIDIA GPU Power: ${gpu_power} W"
else
    echo "AMD GPU Power: ${gpu_power} W"
fi
echo "Total Power: ${total_power} W"
