#!/bin/bash

# Extract CPU power
cpu_power=$(sensors | awk '
  /SVI2_P_Core:/ { core_power = $2 }
  /SVI2_P_SoC:/ { soc_power = $2 }
  END { print core_power + soc_power }
')

# Extract GPU power (handles different PCI bus locations)
gpu_power=$(sensors | awk '
  /amdgpu-pci-/ { in_gpu_section = 1 }
  in_gpu_section && /PPT:/ { print $2; exit }
')

# Handle cases where no value is found
cpu_power=${cpu_power:-0}
gpu_power=${gpu_power:-0}

# Print results
echo "CPU Power: ${cpu_power} W"
echo "GPU Power: ${gpu_power} W"
echo "Total Power: $(echo "$cpu_power + $gpu_power" | bc) W"
