/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.programs;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.irisshaders.iris.gl.GLDebug;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.BufferBlendOverride;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.gl.image.ImageHolder;
import net.irisshaders.iris.gl.program.ProgramImages;
import net.irisshaders.iris.gl.program.ProgramSamplers;
import net.irisshaders.iris.gl.program.ProgramUniforms;
import net.irisshaders.iris.gl.sampler.SamplerHolder;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.gl.uniform.DynamicLocationalUniformHolder;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.samplers.IrisSamplers;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.class_10157;
import net.minecraft.class_1041;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ExtendedShader
extends class_5944 {
    private static final Matrix4f identity = new Matrix4f();
    private static ExtendedShader lastApplied;
    private final boolean intensitySwizzle;
    private final List<BufferBlendOverride> bufferBlendOverrides;
    private final boolean hasOverrides;
    private final class_284 modelViewInverse;
    private final class_284 projectionInverse;
    private final class_284 normalMatrix;
    private final CustomUniforms customUniforms;
    private final IrisRenderingPipeline parent;
    private final ProgramUniforms uniforms;
    private final ProgramSamplers samplers;
    private final ProgramImages images;
    private final GlFramebuffer writingToBeforeTranslucent;
    private final GlFramebuffer writingToAfterTranslucent;
    private final BlendModeOverride blendModeOverride;
    private final float alphaTest;
    private final boolean usesTessellation;
    private final Matrix4f tempMatrix4f = new Matrix4f();
    private final Matrix3f tempMatrix3f = new Matrix3f();
    private final float[] tempFloats = new float[16];
    private final float[] tempFloats2 = new float[9];
    private int textureToUnswizzle;

    public ExtendedShader(int programId, class_5912 resourceFactory, String string, class_293 vertexFormat, boolean usesTessellation, GlFramebuffer writingToBeforeTranslucent, GlFramebuffer writingToAfterTranslucent, BlendModeOverride blendModeOverride, AlphaTest alphaTest, Consumer<DynamicLocationalUniformHolder> uniformCreator, BiConsumer<SamplerHolder, ImageHolder> samplerCreator, boolean isIntensity, IrisRenderingPipeline parent, @Nullable List<BufferBlendOverride> bufferBlendOverrides, CustomUniforms customUniforms) throws IOException {
        super(programId);
        ArrayList<class_10157.class_10159> uniformList = new ArrayList<class_10157.class_10159>();
        ArrayList<class_10157.class_10158> samplerList = new ArrayList<class_10157.class_10158>();
        uniformList.add(new class_10157.class_10159("iris_ModelViewMat", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new class_10157.class_10159("iris_NormalMat", "matrix3x3", 9, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new class_10157.class_10159("iris_ProjMat", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new class_10157.class_10159("iris_TextureMat", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new class_10157.class_10159("iris_ColorModulator", "float", 4, List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f))));
        uniformList.add(new class_10157.class_10159("iris_FogColor", "float", 4, List.of(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f))));
        uniformList.add(new class_10157.class_10159("iris_ModelOffset", "float", 3, List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        uniformList.add(new class_10157.class_10159("iris_FogStart", "float", 1, List.of(Float.valueOf(0.0f))));
        uniformList.add(new class_10157.class_10159("iris_FogEnd", "float", 1, List.of(Float.valueOf(1.0f))));
        uniformList.add(new class_10157.class_10159("iris_GlintAlpha", "float", 1, List.of(Float.valueOf(0.0f))));
        uniformList.add(new class_10157.class_10159("iris_ModelViewMatInverse", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        uniformList.add(new class_10157.class_10159("iris_ProjMatInverse", "matrix4x4", 16, List.of(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        samplerList.add(new class_10157.class_10158("Sampler0"));
        this.method_62900(uniformList, samplerList);
        GLDebug.nameObject(33506, programId, string);
        ProgramUniforms.Builder uniformBuilder = ProgramUniforms.builder(string, programId);
        ProgramSamplers.Builder samplerBuilder = ProgramSamplers.builder(programId, IrisSamplers.WORLD_RESERVED_TEXTURE_UNITS);
        uniformCreator.accept(uniformBuilder);
        ProgramImages.Builder builder = ProgramImages.builder(programId);
        samplerCreator.accept(samplerBuilder, builder);
        customUniforms.mapholderToPass(uniformBuilder, (Object)this);
        this.usesTessellation = usesTessellation;
        this.uniforms = uniformBuilder.buildUniforms();
        this.customUniforms = customUniforms;
        this.samplers = samplerBuilder.build();
        this.images = builder.build();
        this.writingToBeforeTranslucent = writingToBeforeTranslucent;
        this.writingToAfterTranslucent = writingToAfterTranslucent;
        this.blendModeOverride = blendModeOverride;
        this.bufferBlendOverrides = bufferBlendOverrides;
        this.hasOverrides = bufferBlendOverrides != null && !bufferBlendOverrides.isEmpty();
        this.alphaTest = alphaTest.reference();
        this.parent = parent;
        this.modelViewInverse = this.method_34582("ModelViewMatInverse");
        this.projectionInverse = this.method_34582("ProjMatInverse");
        this.normalMatrix = this.method_34582("NormalMat");
        this.intensitySwizzle = isIntensity;
    }

    public boolean isIntensitySwizzle() {
        return this.intensitySwizzle;
    }

    public void method_34585() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        if (this.blendModeOverride != null || this.hasOverrides) {
            BlendModeOverride.restore();
        }
        class_310.method_1551().method_1522().method_1235(false);
        super.method_34585();
    }

    public void method_60897(class_293.class_5596 mode, Matrix4f modelView, Matrix4f projection, class_1041 window) {
        super.method_60897(mode, modelView, projection, window);
        if (this.modelViewInverse != null) {
            this.modelViewInverse.method_1250(modelView.invert(this.tempMatrix4f));
        }
        if (this.normalMatrix != null) {
            this.normalMatrix.method_39978(modelView.invert(this.tempMatrix4f).transpose3x3(this.tempMatrix3f));
        }
        if (this.projectionInverse != null) {
            this.projectionInverse.method_1250(projection.invert(this.tempMatrix4f));
        }
    }

    public void method_34586() {
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        GlStateManager._glUseProgram((int)this.method_1270());
        int i = GlStateManager._getActiveTexture();
        GlStateManager._activeTexture((int)i);
        if (this.intensitySwizzle) {
            IrisRenderSystem.addUnswizzle(RenderSystem.getShaderTexture((int)0));
            IrisRenderSystem.texParameteriv(RenderSystem.getShaderTexture((int)0), TextureType.TEXTURE_2D.getGlType(), 36422, new int[]{6403, 6403, 6403, 6403});
        }
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 0, RenderSystem.getShaderTexture((int)0));
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 1, RenderSystem.getShaderTexture((int)1));
        IrisRenderSystem.bindTextureToUnit(TextureType.TEXTURE_2D.getGlType(), 2, RenderSystem.getShaderTexture((int)2));
        ImmediateState.usingTessellation = this.usesTessellation;
        this.uploadIfNotNull(this.projectionInverse);
        this.uploadIfNotNull(this.modelViewInverse);
        this.uploadIfNotNull(this.normalMatrix);
        this.samplers.update();
        this.uniforms.update();
        List uniformList = this.field_29490;
        for (class_284 uniform : uniformList) {
            this.uploadIfNotNull(uniform);
        }
        this.customUniforms.push((Object)this);
        this.images.update();
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        if (this.hasOverrides) {
            this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
        }
        if (this.parent.isBeforeTranslucent) {
            this.writingToBeforeTranslucent.bind();
        } else {
            this.writingToAfterTranslucent.bind();
        }
    }

    @Nullable
    public class_284 method_34582(@NotNull String name) {
        class_284 uniform = super.method_34582("iris_" + name);
        if (uniform == null && (name.equalsIgnoreCase("OverlayUV") || name.equalsIgnoreCase("LightUV"))) {
            return null;
        }
        return uniform;
    }

    public void method_62900(List<class_10157.class_10159> list, List<class_10157.class_10158> list2) {
        RenderSystem.assertOnRenderThread();
        for (class_10157.class_10159 uniform : list) {
            String string = uniform.comp_3122();
            int i = class_284.method_22096((int)this.method_1270(), (CharSequence)string);
            if (i == -1) continue;
            class_284 uniform2 = this.method_62898(uniform);
            uniform2.method_1297(i);
            this.field_29490.add(uniform2);
            this.field_53841.put(string, uniform2);
        }
        for (class_10157.class_10158 sampler : list2) {
            int j = class_284.method_22096((int)this.method_1270(), (CharSequence)sampler.comp_3121());
            if (j == -1) continue;
            this.field_53838.add(sampler);
            this.field_53840.add(j);
        }
        this.field_29470 = super.method_34582("iris_ModelViewMat");
        this.field_29471 = super.method_34582("iris_ProjMat");
        this.field_29472 = super.method_34582("iris_TextureMat");
        this.field_29473 = super.method_34582("iris_ScreenSize");
        this.field_29474 = super.method_34582("iris_ColorModulator");
        this.field_29475 = super.method_34582("iris_Light0_Direction");
        this.field_29476 = super.method_34582("iris_Light1_Direction");
        this.field_42231 = super.method_34582("iris_GlintAlpha");
        this.field_29477 = super.method_34582("iris_FogStart");
        this.field_29478 = super.method_34582("iris_FogEnd");
        this.field_29479 = super.method_34582("iris_FogColor");
        this.field_36373 = super.method_34582("iris_FogShape");
        this.field_29480 = super.method_34582("iris_LineWidth");
        this.field_29481 = super.method_34582("iris_GameTime");
        this.field_53139 = super.method_34582("iris_ModelOffset");
    }

    private void uploadIfNotNull(class_284 uniform) {
        if (uniform != null) {
            uniform.method_1300();
        }
    }

    public boolean hasActiveImages() {
        return this.images.getActiveImages() > 0;
    }

    static {
        identity.identity();
    }
}

