/*
 * Decompiled with CFR 0.152.
 */
package me.zacharias.speedometer;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.imageio.ImageIO;
import me.zacharias.speedometer.ImageHandler;
import me.zacharias.speedometer.MissingPropertyException;
import me.zacharias.speedometer.Pointer;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.joml.Vector2i;
import org.json.JSONException;
import org.json.JSONObject;

public class SpeedometerIcon {
    private BufferedImage speedometerIcon;
    private Pointer pointer;
    private int start;
    private int end;
    private float scale;
    private int max;
    private boolean overflow;
    private boolean g = false;

    public SpeedometerIcon(JSONObject config, class_3300 resourceManager) throws MissingPropertyException, IOException, JSONException {
        if (!config.has("background")) {
            throw new MissingPropertyException("background");
        }
        Object background = config.getString("background");
        background = ((String)background).contains(":") ? ((String)background).replaceFirst(":", ":textures/") : "textures/" + (String)background;
        Optional speedometerIcon = resourceManager.method_14486((class_2960)class_2960.method_29186((String)background).getOrThrow(s -> new MissingPropertyException("background")));
        if (speedometerIcon.isEmpty()) {
            throw new MissingPropertyException("background");
        }
        InputStream stream = ((class_3298)speedometerIcon.get()).method_14482();
        this.speedometerIcon = ImageIO.read(stream);
        stream.close();
        if (!config.has("start")) {
            throw new MissingPropertyException("start");
        }
        this.start = config.getInt("start");
        if (!config.has("end")) {
            throw new MissingPropertyException("end");
        }
        this.end = config.getInt("end");
        if (!config.has("scale")) {
            throw new MissingPropertyException("scale");
        }
        this.scale = config.getFloat("scale");
        if (!config.has("pointer")) {
            throw new MissingPropertyException("pointer");
        }
        this.pointer = new Pointer(config.getJSONObject("pointer"), resourceManager, new Vector2i(this.speedometerIcon.getWidth(), this.speedometerIcon.getHeight()));
        if (!config.has("maxSpeed")) {
            throw new MissingPropertyException("maxSpeed");
        }
        this.max = config.getInt("maxSpeed");
        if (!config.has("overflow")) {
            throw new MissingPropertyException("overflow");
        }
        this.overflow = config.getBoolean("overflow");
    }

    public BufferedImage getSpeedometerIcon(double speed) {
        BufferedImage img = ImageHandler.clone(this.speedometerIcon);
        Graphics2D graphics = img.createGraphics();
        this.pointer.draw(graphics, this.start, this.end, this.max, this.overflow, Math.pow(speed, this.scale));
        return img;
    }
}

