/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.natamus.collective_common_forge.features.PlayerHeadCacheFeature;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CommandCollective {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"collective").requires(commandSourceStack -> commandSourceStack.isPlayer())).executes(command -> CommandCollective.showCommandHelp((CommandSourceStack)command.getSource()))).then(Commands.literal((String)"help").executes(command -> CommandCollective.showCommandHelp((CommandSourceStack)command.getSource())))).then(Commands.literal((String)"reset").then(Commands.literal((String)"headcache").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            ServerPlayer player = source.getPlayer();
            if (PlayerHeadCacheFeature.resetPlayerHeadCache()) {
                MessageFunctions.sendMessage((Player)player, "The player head cache has successfully been reset.", ChatFormatting.DARK_GREEN);
            }
            return 1;
        }))));
    }

    private static int showCommandHelp(CommandSourceStack source) {
        if (source.hasPermission(2)) {
            MessageFunctions.sendMessage(source, Component.literal((String)"Collective Admin Usage:").withStyle(ChatFormatting.GOLD), true);
            MessageFunctions.sendMessage(source, " /collective reset headcache", ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage(source, "     Resets Collective's cached player head data, to for example update skins.", ChatFormatting.GRAY);
        }
        return 1;
    }
}

