/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.schematic;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.schematic.ParsedSchematicObject;
import com.natamus.collective_common_neoforge.schematic.Schematic;
import com.natamus.collective_common_neoforge.schematic.SchematicBlockObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ParseSchematicFile {
    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, Level level, BlockPos centerPos, int extraYOffset, boolean skipAir) {
        return ParseSchematicFile.getParsedSchematicObject(schematicInputStream, level, centerPos, extraYOffset, skipAir, true);
    }

    public static ParsedSchematicObject getParsedSchematicObject(InputStream schematicInputStream, Level level, BlockPos centerPos, int extraYOffset, boolean skipAir, boolean automaticCenter) {
        Schematic schematic = new Schematic(schematicInputStream, level);
        int maxBuildHeight = level.getMaxY();
        short length = schematic.getLength();
        short width = schematic.getWidth();
        short height = schematic.getHeight();
        int xoffset = schematic.getOffsetX();
        int yoffset = centerPos.getY() + extraYOffset;
        int zoffset = schematic.getOffsetZ();
        if (automaticCenter) {
            xoffset = -(width / 2);
            if (yoffset + height > maxBuildHeight) {
                yoffset = maxBuildHeight - height;
            }
            zoffset = -(length / 2);
        } else {
            yoffset += schematic.getOffsetY();
        }
        ArrayList<Pair<BlockPos, BlockState>> blocks = new ArrayList<Pair<BlockPos, BlockState>>();
        for (SchematicBlockObject blockObject : schematic.getBlocks()) {
            if (blockObject == null) continue;
            BlockState blockState = blockObject.getState();
            if (skipAir && blockState.getBlock().equals(Blocks.AIR)) continue;
            blocks.add(new Pair((Object)blockObject.getPosition().offset(centerPos.getX() + xoffset, yoffset, centerPos.getZ() + zoffset).immutable(), (Object)blockState));
        }
        ArrayList<Pair<BlockPos, Entity>> entities = new ArrayList<Pair<BlockPos, Entity>>();
        for (Pair<BlockPos, CompoundTag> rawEntityPair : schematic.getEntityRelativePosPairs()) {
            Optional optionalNewEntity = EntityType.create((CompoundTag)((CompoundTag)rawEntityPair.getSecond()), (Level)level, (EntitySpawnReason)EntitySpawnReason.STRUCTURE);
            if (!optionalNewEntity.isPresent()) continue;
            BlockPos actualEntityPosition = ((BlockPos)rawEntityPair.getFirst()).offset(centerPos.getX() + xoffset, yoffset, centerPos.getZ() + zoffset).immutable();
            Entity newEntity = (Entity)optionalNewEntity.get();
            newEntity.setPos((double)actualEntityPosition.getX() + 0.5, (double)actualEntityPosition.getY(), (double)actualEntityPosition.getZ() + 0.5);
            entities.add((Pair<BlockPos, Entity>)new Pair((Object)actualEntityPosition, (Object)newEntity));
        }
        ArrayList<BlockPos> blockEntityPositions = new ArrayList<BlockPos>();
        for (CompoundTag blockEntityCompoundTag : schematic.getBlockEntities()) {
            blockEntityPositions.add(schematic.getBlockPosFromCompoundTag(blockEntityCompoundTag).offset(centerPos.getX() + xoffset, yoffset, centerPos.getZ() + zoffset));
        }
        return new ParsedSchematicObject(schematic, blocks, entities, blockEntityPositions, "Parsed successfully.", true);
    }
}

