/*
 * Decompiled with CFR 0.152.
 */
package me.zacharias.speedometer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import me.zacharias.speedometer.Config;
import me.zacharias.speedometer.Debugger;
import me.zacharias.speedometer.ImageHandler;
import me.zacharias.speedometer.MissingPropertyException;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.joml.Vector2i;
import org.json.JSONException;
import org.json.JSONObject;

class Pointer {
    private BufferedImage image;
    private Color color;
    private Vector2i start;
    private int length;
    private boolean g = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pointer(JSONObject pointer, class_3300 resourceManager, Vector2i size) throws MissingPropertyException, IOException, JSONException {
        String str;
        if (!pointer.has("start")) {
            throw new MissingPropertyException("pointer/start");
        }
        Object object = pointer.get("start");
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            if (!jsonObject.has("x")) {
                throw new MissingPropertyException("pointer/start/x");
            }
            if (!jsonObject.has("y")) {
                throw new MissingPropertyException("pointer/start/y");
            }
            this.start = new Vector2i(jsonObject.getInt("x"), jsonObject.getInt("y"));
        } else {
            object = pointer.get("start");
            if (object instanceof String) {
                str = (String)object;
                if (str.isEmpty()) {
                    throw new MissingPropertyException("pointer/start");
                }
                if (str.matches("^\\([0-9]+,( )?[0-9]+\\)+$")) {
                    String[] split = str.split(",");
                    this.start = new Vector2i(Integer.parseInt(split[0].substring(1)), Integer.parseInt(split[1].substring(0, split[1].length() - 1)));
                } else {
                    if (!str.equalsIgnoreCase("center")) throw new MissingPropertyException("pointer/start");
                    this.start = new Vector2i(size.x / 2, size.y / 2);
                }
            }
        }
        if (pointer.has("image")) {
            Object imageResourceLocation = pointer.getString("image");
            imageResourceLocation = ((String)imageResourceLocation).contains(":") ? ((String)imageResourceLocation).replaceFirst(":", ":textures/") : "textures/" + (String)imageResourceLocation;
            Optional image = resourceManager.method_14486((class_2960)class_2960.method_29186((String)imageResourceLocation).getOrThrow(s -> new MissingPropertyException("pointer/image")));
            if (image.isEmpty()) {
                throw new MissingPropertyException("pointer/image");
            }
            InputStream stream = ((class_3298)image.get()).method_14482();
            this.image = ImageHandler.scale(ImageIO.read(stream), size.x, size.y);
            stream.close();
            return;
        } else {
            if (!pointer.has("length")) throw new MissingPropertyException("pointer/image or pointer/length");
            object = pointer.get("length");
            if (object instanceof String) {
                str = (String)object;
                this.length = switch (str.toLowerCase()) {
                    case "half" -> size.x / 2;
                    case "full" -> size.x;
                    default -> throw new MissingPropertyException("pointer/length");
                };
            } else {
                object = pointer.get("length");
                if (!(object instanceof Integer)) throw new MissingPropertyException("pointer/length");
                Integer integer = (Integer)object;
                this.length = integer;
            }
            if (!pointer.has("color")) throw new MissingPropertyException("pointer/color");
            String c = pointer.getString("color");
            if (!c.matches("^#[0-9a-fA-F]{6}$")) {
                throw new MissingPropertyException("pointer/color");
            }
            this.color = new Color(Integer.parseInt(c.substring(1), 16));
        }
    }

    public void draw(Graphics2D g2d, int start, int end, int max, boolean overflow, double speed) {
        double angle;
        Color c = this.color;
        if (Config.isOverrideColor()) {
            c = Config.getColor();
        }
        if ((angle = speed / (double)max * (double)end + (double)start) > (double)end && !overflow) {
            angle = end;
        }
        Debugger.angle = angle;
        if (Objects.nonNull(this.image)) {
            int centerX = this.start.x;
            int centerY = this.start.y;
            BufferedImage image = ImageHandler.rotateImage(this.image, angle, centerX, centerY);
            g2d.drawImage((Image)image, 0, 0, null);
        } else if (c != null && this.length > 0) {
            double angleRads = Math.toRadians(180.0 + angle);
            int endX = (int)(Math.cos(angleRads) * (double)this.length + (double)this.start.x);
            int endY = (int)(Math.sin(angleRads) * (double)this.length + (double)this.start.y);
            Debugger.x = endX;
            Debugger.y = endY;
            g2d.setColor(c);
            g2d.setStroke(new BasicStroke(3.0f, 1, 1));
            g2d.drawLine(this.start.x, this.start.y, endX, endY);
        } else {
            Config.setDisableVisualSpeedometer(true);
            throw new NullPointerException("image and line pointer both are undefined");
        }
    }
}

