/*
 * Decompiled with CFR 0.152.
 */
package net.notcoded.wayfix.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.class_310;
import net.minecraft.class_7367;
import net.notcoded.wayfix.WayFix;
import net.notcoded.wayfix.util.XDGPathResolver;
import org.apache.commons.io.IOUtils;

public class DesktopFileInjector {
    public static final String APP_ID = "com.mojang.minecraft.java-edition";
    private static final String ICON_NAME = "minecraft.png";
    private static final String FILE_NAME = "com.mojang.minecraft.java-edition.desktop";
    private static final String RESOURCE_LOCATION = "/assets/wayfix/com.mojang.minecraft.java-edition.desktop";

    public static void inject() {
        try (InputStream stream = DesktopFileInjector.class.getResourceAsStream(RESOURCE_LOCATION);){
            Path location = DesktopFileInjector.getDesktopFileLocation();
            String desktop = System.getenv("XDG_CURRENT_DESKTOP");
            String version = class_310.method_1551().method_1515();
            DesktopFileInjector.injectFile(location, String.format(IOUtils.toString((InputStream)Objects.requireNonNull(stream), (Charset)StandardCharsets.UTF_8), version, ICON_NAME.substring(0, ICON_NAME.lastIndexOf(".")), !desktop.contains("GNOME") ? "Hidden=true" : "").getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            WayFix.LOGGER.error("Failed to inject icon: ", (Throwable)e);
        }
    }

    public static void setIcon(List<class_7367<InputStream>> icons) {
        if (!WayFix.config.injectIcon) {
            return;
        }
        for (class_7367<InputStream> supplier : icons) {
            try {
                BufferedImage image = ImageIO.read((InputStream)supplier.get());
                Path target = DesktopFileInjector.getIconFileLocation(image.getWidth(), image.getHeight());
                DesktopFileInjector.injectFile(target, IOUtils.toByteArray((InputStream)((InputStream)supplier.get())));
            }
            catch (IOException e) {
                return;
            }
        }
        DesktopFileInjector.updateIconSystem();
    }

    private static void injectFile(Path target, byte[] data) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            new File(String.valueOf(Files.write(target, data, new OpenOption[0]))).deleteOnExit();
        }
        catch (IOException e) {
            WayFix.LOGGER.error("Failed to inject file: ", (Throwable)e);
        }
    }

    private static Path getIconFileLocation(int width, int height) {
        return XDGPathResolver.getUserDataLocation().resolve("icons/hicolor").resolve(width + "x" + height).resolve("apps").resolve(ICON_NAME);
    }

    private static Path getDesktopFileLocation() {
        return XDGPathResolver.getUserDataLocation().resolve("applications").resolve(FILE_NAME);
    }

    private static void updateIconSystem() {
        String desktop = System.getenv("XDG_CURRENT_DESKTOP");
        String[] process = new String[]{"xdg-icon-resource", "forceupdate"};
        if (desktop.contains("KDE")) {
            process = new String[]{"dbus-send", "--session", "/KGlobalSettings", "org.kde.KGlobalSettings.notifyChange", "int32:0", "int32:0"};
        } else if (desktop.contains("GNOME")) {
            process = new String[]{"gtk-update-icon-cache"};
        }
        ProcessBuilder builder = new ProcessBuilder(process);
        try {
            builder.start();
        }
        catch (IOException ignored) {
            WayFix.LOGGER.warn("Failed to update the icon cache, you might see the incorrect icons for the game.");
        }
    }
}

