/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.model.item;

import java.util.List;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.client.model.quad.BakedQuadView;
import net.caffeinemc.mods.sodium.client.render.immediate.model.BakedModelEncoder;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_777;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_918.class})
public abstract class ItemRendererMixin {
    @Unique
    private static final ThreadLocal<class_5819> random = ThreadLocal.withInitial(() -> new class_6575(42L));

    @Shadow
    private static int method_65569(int[] is, int i) {
        throw new AssertionError((Object)"Not shadowed");
    }

    @Inject(method={"method_23182(Lnet/minecraft/class_1087;[IIILnet/minecraft/class_4587;Lnet/minecraft/class_4588;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderModelFast(class_1087 model, int[] colors, int light, int overlay, class_4587 poseStack, class_4588 vertexConsumer, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        class_5819 random = ItemRendererMixin.random.get();
        long seed = 42L;
        class_4587.class_4665 matrices = poseStack.method_23760();
        for (class_2350 direction : DirectionUtil.ALL_DIRECTIONS) {
            random.method_43052(42L);
            List quads = model.method_4707(null, direction, random);
            if (quads.isEmpty()) continue;
            ItemRendererMixin.renderBakedItemQuads(matrices, writer, quads, colors, light, overlay);
        }
        random.method_43052(42L);
        List quads = model.method_4707(null, null, random);
        if (!quads.isEmpty()) {
            ItemRendererMixin.renderBakedItemQuads(matrices, writer, quads, colors, light, overlay);
        }
    }

    @Unique
    private static void renderBakedItemQuads(class_4587.class_4665 matrices, VertexBufferWriter writer, List<class_777> quads, int[] colors, int light, int overlay) {
        for (int i = 0; i < quads.size(); ++i) {
            class_777 bakedQuad = quads.get(i);
            if (bakedQuad.method_3357().length < 32) continue;
            BakedQuadView quad = (BakedQuadView)bakedQuad;
            int color = -1;
            if (bakedQuad.method_3360()) {
                color = ColorARGB.toABGR(ItemRendererMixin.method_65569(colors, bakedQuad.method_3359()));
            }
            BakedModelEncoder.writeQuadVertices(writer, matrices, quad, color, light, overlay, BakedModelEncoder.shouldMultiplyAlpha());
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
    }
}

